package coreservlets.tags;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import java.io.*;

/** Klasa obsugi niestandardowego znacznika forEach.
 *  Klasa potrafi iterowa po tablicy obiektw.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class ForEachTag extends SimpleTagSupport {
  private Object[] items;
  private String attributeName;

  public void setItems(Object[] items) {
    this.items = items;
  }

  public void setVar(String attributeName) {
    this.attributeName = attributeName;
  }

  public void doTag() throws JspException, IOException {
    for(int i=0; i<items.length; i++) {
      getJspContext().setAttribute(attributeName, items[i]);
      getJspBody().invoke(null);
    }
  }
}
